﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using TP7.model;

namespace TP7.dao
{
    public class EtudiantDAO
    {
        public static string ETUDIANT_XML = @"c:\formationCSharpTP7\etudiants.xml";
        private List<Etudiant> etudiants;

        public EtudiantDAO()
        {
            string rep = @"c:\formationCSharpTP7\";
            if (!Directory.Exists(rep))
            {
                Directory.CreateDirectory(rep);
                init();
            }
            etudiants = getEtudiants();
        }

        public List<Etudiant> getEtudiants()
        {
            List<Etudiant> etudiants = null;
            XmlSerializer xs = new XmlSerializer(typeof(List<Etudiant>));
            StreamReader sr = null;
            try
            {
                sr = new StreamReader(ETUDIANT_XML);
                etudiants = xs.Deserialize(sr) as List<Etudiant>;
            }
            catch (Exception e)
            {
                Console.WriteLine("Problème lors de l'écriture du fichier xml: " + e.Message);
            }
            finally
            {
                if (sr!=null) sr.Close();
            }
            return etudiants;
        }

        public Etudiant getEtudiantByNumero(int num)
        {
            Etudiant etudiant = null;
            foreach (Etudiant item in etudiants)
            {
                if (item.Numero.Equals(num))
                {
                    etudiant = item;
                    break;
                }
            }
            return etudiant;
        }

        public void saveEtudiant(Etudiant etudiant)
        {
            Etudiant etu = getEtudiantByNumero(etudiant.Numero);
            if (etu == null)
            {
                //L'étudiant n'existe pas : il faut l'ajouter à la liste
                etudiants.Add(etudiant);
            }
            else
            {
                //L'étudiant existe : il faut le modifier
                etu = etudiant;
            }
            saveListe();
        }

        public void saveListe()
        {
            XmlSerializer xs = new XmlSerializer(typeof(List<Etudiant>));
            StreamWriter sr = null;
            try
            {
                sr = new StreamWriter(ETUDIANT_XML);
                xs.Serialize(sr,etudiants);
            }
            catch (Exception e)
            {
                Console.WriteLine("Problème lors de l'écriture du fichier xml: " + e.Message);
            }
            finally
            {
                if (sr != null) sr.Close();
            }
        }

        private void init()
        {
            //Initialise une première liste d'étudiants
            etudiants = new List<Etudiant>();
            for (int i = 1; i <= 10; i++)
            {
                etudiants.Add(new Etudiant(i, "DUPONT_" + i, "Jean_" + i, DateTime.Now.AddYears(-20).AddDays(i), "M", 10 + i, new Formation(Formation.LP)));
            }
            saveListe();
        }
    }
}
