﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TP7.model
{
    public class Etudiant : Personne
    {
        private int numero;
        private Formation formation;
        private int anneeEntree;

        public Etudiant() { }

        public Etudiant(int id, string nom, string prenom, DateTime date, string sexe, int num, Formation formation)
        {
            base.Id = id;
            base.nom = nom; //utilisation des attributs de Personne
            base.prenom = prenom;
            base.DateNaissance = date;
            base.Sexe = sexe;
            this.numero = num;
            this.formation = formation;
        }

        public int Numero
        {
            get { return numero; }
            set { numero = value; }
        }

        public override bool Equals(object obj)
        {
            // si le paramètre ne peut pas être casté, on retourne false
            Etudiant e = obj as Etudiant;
            if ((object)e == null) return false;

            return this.numero.Equals(e.numero);
        }

        public override string ToString()
        {
            return this.prenom + " " + this.nom;
        }

        public override int GetHashCode()
        {
            return this.numero.GetHashCode();
        }

        public Formation Formation
        {
            get { return formation; }
            set { formation = value; }
        }

        public int AnneeEntree
        {
            get { return anneeEntree; }
            set { anneeEntree = value; }
        }


        public override string getActivite()
        {
            return "Etudie";
        }

        public override int getAnciennete()
        {
            return DateTime.Now.Year - anneeEntree;
        }


    }

}
