﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using TP7.model;
using TP7.dao;

namespace TP7.form
{
    public partial class EtudiantForm : Form
    {
        private Etudiant etudiant;
        private EtudiantDAO eDAO;

        public EtudiantForm()
        {
            InitializeComponent();
            eDAO = new EtudiantDAO();
            etudiant = new Etudiant();
            FormationDAO fDAO = new FormationDAO();
            comboBoxFormation.DataSource = fDAO.getFormations();
            comboBoxFormation.DisplayMember = "Nom";
        }

        public EtudiantForm(Etudiant etudiant) : this()
        {
            this.Etudiant = etudiant;
            initialisation();
        }

        public Etudiant Etudiant
        {
          get { return etudiant; }
          set { etudiant = value; }
        }

        public void initialisation()
        {
            //Initialisation des TextBox
            textBoxNom.Text = etudiant.Nom;
            textBoxPrenom.Text = etudiant.Prenom;
            //Initialisation du DateTimePicker
            if (etudiant.Nom != null && !etudiant.Nom.Equals(""))
            {
                dateTimePickerDateNaissance.Value = etudiant.DateNaissance;
            }
            else
            {
                dateTimePickerDateNaissance.Value = DateTime.Today;
            }
            //Initialisation des RadioButtons
            radioButtonHomme.Checked = (etudiant.Sexe == "M");
            radioButtonFemme.Checked = (etudiant.Sexe == "F");
            //Initialisation de la ComboBox
            FormationDAO fDAO = new FormationDAO();
            comboBoxFormation.DataSource = fDAO.getFormations();
            comboBoxFormation.SelectedItem = etudiant.Formation;
            comboBoxFormation.DisplayMember = "Nom";
        }

        

        private void btnAnnuler_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            //Message de confirmation
            DialogResult dr = MessageBox.Show("Souhaitez-vous sauvegarder ?", "Sauvegarde", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (dr.Equals(DialogResult.Yes))
            {
                saveEtudiant();
            }
        }

        private void saveEtudiant()
        {
            //Récupération de la saisie sur un TextBox
            int numero;
            bool ok = int.TryParse(textBoxNumCarte.Text, out numero);
            if (ok)
            {
                etudiant.Numero = numero;
                etudiant.Nom = textBoxNom.Text;
                etudiant.Prenom = textBoxPrenom.Text;
                //Récupération de la saisie sur un DateTimePicker
                etudiant.DateNaissance = dateTimePickerDateNaissance.Value;
                //Récupération de la saisie sur un Radiobutton
                etudiant.Sexe = "M";
                if (radioButtonFemme.Checked) etudiant.Sexe = "F";
                //Récupération de la saisie sur un ComboBox
                etudiant.Formation = (Formation)comboBoxFormation.SelectedItem;
                //Message d'information
                eDAO.saveEtudiant(etudiant);
                MessageBox.Show("Sauvegarde réussie", "Sauvegarde", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else
            {
                MessageBox.Show("Erreur dans la saisie du numéro", "Validation", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnAjouter_Click(object sender, EventArgs e)
        {
            etudiant = new Etudiant();
            etudiant.Numero = 0;
            textBoxNumCarte.Text = "";
            initialisation();
        }

        private void btnValider_Click(object sender, EventArgs e)
        {
            int num = int.Parse(textBoxNumCarte.Text);
            etudiant = eDAO.getEtudiantByNumero(num);
            if (etudiant != null) initialisation();
        }

    }
}


