﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TP6
{
    public class Etudiant : Personne
    {
        private int numero;
        private Formation formation;
        private int anneeEntree;

        public override string getActivite()
        {
            return "Etudie";
        }

        public override int getAnciennete()
        {
            return DateTime.Now.Year - anneeEntree;
        }


        public Etudiant() { }

        /// <summary>
        /// Constructeur de la classe Edudiant
        /// </summary>
        /// <param name="nom">Nom de l'étudiant</param>
        /// <param name="prenom">Prénom de l'étudiant</param>
        /// <param name="num">Numéro de la carte étudiant</param>
        /// <param name="formation">Classe Formation</param>
        public Etudiant(int id, string nom, string prenom, int num, Formation formation)
        {
            base.Id = id;
            base.nom = nom; //utilisation des attributs de Personne
            base.prenom = prenom;
            this.numero = num;
            this.formation = formation;
        }


        public int Numero
        {
            get { return numero; }
            set { numero = value; }
        }

        public bool isDupont()
        {
            return nom.Equals("Dupont");
        }




        public override bool Equals(object obj)
        {
            // si le paramètre ne peut pas être casté, on retourne false
            Etudiant e = obj as Etudiant;
            if ((object)e == null) return false;

            return this.numero.Equals(e.numero);
        }

        public override string ToString()
        {
            return this.prenom + " " + this.nom;
        }

        public override int GetHashCode()
        {
            return this.numero.GetHashCode();
        }

        public Formation Formation
        {
            get { return formation; }
            set { formation = value; }
        }

        public int AnneeEntree
        {
            get { return anneeEntree; }
            set { anneeEntree = value; }
        }
    }

}
