﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Xml;

namespace TP6
{
    public class Program
    {
        static void Main(string[] args)
        {
            //1ère partie : écriture dans un fichier texte
            List<Etudiant> etudiants = new List<Etudiant>();            
            for (int i = 1; i <= 10; i++)
            {
                etudiants.Add(new Etudiant(i, "DUPONT_"+i, "Jean_"+i, 10+i, new Formation(Formation.LP)));
            }

            string rep = @"c:\formationCSharpTP6\";
            if (!Directory.Exists(rep)) Directory.CreateDirectory(rep);

            StreamWriter sw = null;
            string fichier = rep + "etudiants.txt";
            try
            {
                sw = new StreamWriter(fichier);
                foreach (Etudiant item in etudiants)
                {
                    sw.WriteLine(item.Nom + ";" + item.Prenom + ";" + item.Numero);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Problème lors de l'écriture du fichier txt: " + e.Message);
            }
            finally
            {
                sw.Close();
            }

            //2eme partie sérialisation de la liste
            XmlSerializer xs = new XmlSerializer(typeof(List<Etudiant>));
            try
            {
                sw = new StreamWriter(rep + "etudiants.xml");
                xs.Serialize(sw,etudiants);
            }
            catch (Exception e)
            {
                Console.WriteLine("Problème lors de l'écriture du fichier xml: " + e.Message);
            }
            finally
            {
                sw.Close();
            }

            //3e partie : lecture du fichier XML
            XmlDocument xmlDocument = new XmlDocument();
            try
            {
                xmlDocument.Load(rep + "etudiants.xml");
                XmlElement arrayEtudiant = xmlDocument.DocumentElement;
                foreach (XmlNode nodeEtudiant in arrayEtudiant.ChildNodes)
	            {
                    string nom = nodeEtudiant.SelectSingleNode("Nom").InnerText;   ///[1].InnerText;
                    string prenom = nodeEtudiant.ChildNodes[2].InnerText;
                    Console.WriteLine(nom+" "+prenom);
	            }
            }
            catch (Exception e)
            {
                Console.WriteLine("Problème pendant la lecture du fichier XML :" + e.Message);
            }
            Console.Read();

        }
    }
}
