﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TP4
{
    public class Program
    {
        static void Main(string[] args)
        {
            List<Etudiant> etudiants = new List<Etudiant>();
            Etudiant e1 = new Etudiant(1, "BREILLE", "Jean", DateTime.Parse("12/03/1997"));
            Etudiant e2 = new Etudiant(2, "CELAIRE", "Jacques", DateTime.Parse("25/04/1998"));
            Etudiant e3 = new Etudiant(3, "CONDA", "Anna", DateTime.Parse("28/09/1995"));
            Etudiant e4 = new Etudiant(4, "GALE", "Martin", DateTime.Parse("12/11/1997"));

            etudiants.Add(e1);
            etudiants.Add(e2);
            etudiants.Add(e3);
            etudiants.Add(e4);

            //Trier la liste des étudiants par date de naissance
            List<Etudiant> etudiantsTriesParDate = etudiants.OrderBy(e => e.DateDeNaissance).ToList();
            //Afficher la liste triée
            etudiantsTriesParDate.ForEach(e => Console.WriteLine(e));

            //Calculer l'age moyen
            double ageMoyen = etudiants.Average(e => DateTime.Now.Year - e.DateDeNaissance.Year);
            Console.WriteLine("Age moyen : " + ageMoyen);

            //Aficher le nombre d'étudiant par année de naissance
            var result = etudiants.GroupBy(e => e.DateDeNaissance.Year).Select(g => new { annee = g.Key, nombre = g.Count() }).OrderBy(g => g.annee).ToList();
            result.ForEach(r => Console.WriteLine(r.annee+" : "+r.nombre));



            Console.Read();

        }
    }
}
