﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TP3
{
    public class Etudiant
    {
        private int numero;
        private string nom;
        private string prenom;
        private DateTime dateDeNaissance;

        public Etudiant() { }

        public Etudiant(int num)
        {
            this.numero = num;
        }

        public Etudiant(int num, string nom, string prenom)
        {
            this.numero = num;
            this.nom = nom;
            this.prenom = prenom;
        }

        public Etudiant(int num, string nom, string prenom, DateTime date)
        {
            this.numero = num;
            this.nom = nom;
            this.prenom = prenom;
            this.dateDeNaissance = date;
        }

        public int Numero
        {
            get { return numero; }
            set { numero = value; }
        }

        public string Nom
        {
            get { return nom; }
            set { nom = value; }
        }

        public string Prenom
        {
            get { return prenom; }
            set { prenom = value; }
        }

        public DateTime DateDeNaissance
        {
            get { return dateDeNaissance; }
            set { dateDeNaissance = value; }
        }

        public override bool Equals(object obj)
        {
            // si le paramètre ne peut pas être casté, on retourne false
            Etudiant e = obj as Etudiant;
            if ((object)e == null) return false;

            return this.numero.Equals(e.numero);
        }

        public override string ToString()
        {
            return this.prenom + " " + this.nom;
        }

        public override int GetHashCode()
        {
            return this.numero.GetHashCode();
        }

        public void affiche()
        {
            Console.WriteLine(this.numero + " : " + this.dateDeNaissance.ToShortDateString());
        }


        
    }

}
