﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TP3
{
    public class Universite
    {
        private List<Etudiant> etudiants;

        public Universite() { }

        public Universite(List<Etudiant> liste)
        {
            this.etudiants = liste;
        }

        public List<Etudiant> Etudiants
        {
            get { return etudiants; }
            set { etudiants = value; }
        }

        /// <summary>
        /// Ajoute un étudiant dans la liste
        /// </summary>
        /// <param name="etudiant">de type Etudiant</param>
        /// <exception cref="EtudiantExisteDejaException">Si l'étudiant existe déjà dans la liste</exception>
        public void ajoute(Etudiant etudiant)
        {
            if (etudiants == null) etudiants = new List<Etudiant>();
            if (this.etudiants.Contains(etudiant))
            {
                throw new EtudiantExisteDejaException(etudiant);
            }
            else
            {
                etudiants.Add(etudiant);
            }
        }



        public Etudiant getEtudiant(int numero)
        {
            Etudiant etudiant=null;
            foreach (Etudiant item in etudiants)
            {
                if (item.Numero.Equals(numero))
                {
                    etudiant = item;
                    break;
                }
            }
            return etudiant;
        }

    }
}
